io.stdout:setvbuf("no")                -- Allows Sublime Text to print in real time

-- Screen information
_Screen = {
	width = 1280;
	height = 720;
	windowFocus = true;
	mouseLock = false;
	focus = "game";
};

_NetworkConfig = {
	svSyncRate =  60.0;
	clSyncRate = 60.0;
	clUpdateRate = 60.0;
	clInterp = 0.04;
	clExtrap = 0.02;
	fakeLag = 0.0;
	reliablePeriod = 0.10;
}

-- Party mode?
-- _PARTY = true;


function love.conf(t)
	t.identity = "Move Or Die"         -- The name of the save directory (string)
	t.version = "0.9.1"                -- The LÖVE version this game was made for (string)

	t.window.title = "Move Or Die"     -- The window title (string)
	t.window.icon = nil                -- Filepath to an image to use as the window's icon (string)

	t.window.width = 960               -- The window width (number)
	t.window.height = 540               -- The window height (number)
	t.window.borderless = false         -- Remove all border visuals from the window (boolean)
	t.window.resizable = false         -- Let the window be user-resizable (boolean)
	t.window.minwidth = 960              -- Minimum window width if the window is resizable (number)
	t.window.minheight = 540            -- Minimum window height if the window is resizable (number)
	t.window.fullscreen = false        -- Enable fullscreen (boolean)
	t.window.fullscreentype = "normal" -- Standard fullscreen or desktop fullscreen mode (string)
	t.window.vsync = false              -- Enable vertical sync (boolean)
	t.window.fsaa = 0                  -- The number of samples to use with multi-sampled antialiasing (number)
	t.window.display = 1               -- Index of the monitor to show the window in (number)
	t.window = nil;

	t.modules.audio = true             -- Enable the audio module (boolean)
	t.modules.steam = true             -- Enable the steam module (boolean)
	t.modules.event = true             -- Enable the event module (boolean)
	t.modules.graphics = true          -- Enable the graphics module (boolean)
	t.modules.image = true             -- Enable the image module (boolean)
	t.modules.joystick = true          -- Enable the joystick module (boolean)
	t.modules.keyboard = true          -- Enable the keyboard module (boolean)
	t.modules.math = true              -- Enable the math module (boolean)
	t.modules.mouse = true             -- Enable the mouse module (boolean)
	t.modules.physics = true           -- Enable the physics module (boolean)
	t.modules.sound = true             -- Enable the sound module (boolean)
	t.modules.system = true            -- Enable the system module (boolean)
	t.modules.timer = true             -- Enable the timer module (boolean)
	t.modules.window = true            -- Enable the window module (boolean)

	if love._os ~= "Windows" then
		love.filesystem.setSymlinksEnabled(true)
	end
end
